
import gurobi

def solve_pet_store_mixture_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x_A = model.addVar(name="x_A", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x_B = model.addVar(name="x_B", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(3.50 * x_A + 2.50 * x_B, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3 * x_A + 4 * x_B >= 30, name="protein_requirement")
    model.addConstr(4 * x_A + 2 * x_B >= 35, name="calcium_requirement")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Bag A: {x_A.varValue} bags")
        print(f"Bag B: {x_B.varValue} bags")
        print(f"Total Cost: ${model.objVal:.2f}")
    else:
        print("The problem is infeasible.")

solve_pet_store_mixture_problem()
