
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("office_design")

# Create decision variables
x = model.addVar(vtype=GRB.INTEGER, name="regular_desks")
y = model.addVar(vtype=GRB.INTEGER, name="standing_desks")

# Set objective function
model.setObjective(4*x + 6*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(150*x + 200*y <= 2500, "budget")
model.addConstr(6*x + 5*y <= 250, "space")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Number of regular desks: {x.x}")
    print(f"Number of standing desks: {y.x}")
    print(f"Total seating capacity: {model.objVal}")
else:
    print("Infeasible or unbounded")

