
import gurobi

def solve_desk_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    R = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="RegularDesks")
    S = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="StandingDesks")

    # Objective: Maximize seating capacity
    model.setObjective(4*R + 6*S, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(150*R + 200*S <= 2500, name="BudgetConstraint")

    # Space constraint
    model.addConstr(6*R + 5*S <= 250, name="SpaceConstraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {R.varName} = {R.x}, {S.varName} = {S.x}")
        print(f"Max seating capacity: {4*R.x + 6*S.x}")
    else:
        print("No optimal solution found")

solve_desk_problem()
