
import gurobipy as gp

# Create a new model
model = gp.Model("FishFoodProduction")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="small_containers")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bulk_containers")

# Set objective function
model.setObjective(2*x + 7*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10*x + 30*y <= 200, "fish_food_constraint")
model.addConstr(2*x + 7*y <= 120, "time_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Number of small containers: {x.x:.2f}")
    print(f"Number of bulk containers: {y.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

