
from gurobipy import *

# Create a new model
m = Model("Fish Food Production")

# Define the decision variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="small_containers")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="bulk_containers")

# Set the objective function to maximize profit
m.setObjective(2*x + 7*y, GRB.MAXIMIZE)

# Add constraints: fish food availability and filling time
m.addConstr(10*x + 30*y <= 200, "fish_food_availability")
m.addConstr(2*x + 7*y <= 120, "filling_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Produce {x.x} small containers and {y.x} bulk containers.")
    print(f"Maximum profit: ${2*x.x + 7*y.x}")
else:
    print("No optimal solution found.")
