
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the decision variables
s = m.addVar(lb=0, name="small_containers")
b = m.addVar(lb=0, name="bulk_containers")

# Define the objective function
m.setObjective(2 * s + 7 * b, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(10 * s + 30 * b <= 200, name="fish_food_constraint")
m.addConstr(2 * s + 7 * b <= 120, name="filling_time_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of small containers: {s.varValue}")
    print(f"Number of bulk containers: {b.varValue}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found.")
