
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Fitness_Equipment_Optimization")

# Create decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="treadmills")
y = m.addVar(vtype=GRB.CONTINUOUS, name="bikes")


# Set objective function
m.setObjective(300*x + 120*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x + 15*y <= 10000, "mover_time")
m.addConstr(50*x + 30*y <= 15000, "setup_time")
m.addConstr(x >= 0, "treadmills_non_negative")  # explicitly add non-negativity
m.addConstr(y >= 0, "bikes_non_negative")  # explicitly add non-negativity


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Treadmills: {x.x}")
    print(f"Number of Bikes: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

