
from gurobipy import *

# Create a new model
model = Model("Fitness_Equipment_Optimization")

# Define the decision variables
x = model.addVar(vtype=GRB.INTEGER, name="treadmills", lb=0)
y = model.addVar(vtype=GRB.INTEGER, name="stationary_bikes", lb=0)

# Set the objective function
model.setObjective(300*x + 120*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(30*x + 15*y <= 10000, "mover_time")
model.addConstr(50*x + 30*y <= 15000, "setup_time")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Treadmills: {x.x}")
    print(f"Stationary Bikes: {y.x}")
    print(f"Max Profit: ${300*x.x + 120*y.x:.2f}")
else:
    print("No optimal solution found")
