
import gurobi

def solve_fitness_company_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    treadmills = model.addVar(lb=0, name="treadmills", vtype=gurobi.GRB.CONTINUOUS)
    stationary_bikes = model.addVar(lb=0, name="stationary_bikes", vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(300 * treadmills + 120 * stationary_bikes, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(30 * treadmills + 15 * stationary_bikes <= 10000, name="mover_time")
    model.addConstr(50 * treadmills + 30 * stationary_bikes <= 15000, name="setup_time")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: treadmills = {treadmills.varValue:.2f}, stationary_bikes = {stationary_bikes.varValue:.2f}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found")

solve_fitness_company_problem()
