
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("ToyProduction")

# Create decision variables
x = model.addVar(vtype=GRB.INTEGER, name="drones")  # Number of drones, integer
y = model.addVar(vtype=GRB.INTEGER, name="cars")  # Number of cars, integer


# Set objective function
model.setObjective(50*x + 90*y, GRB.MAXIMIZE)

# Add constraints
model.addConstr(7*x + 4*y <= 200, "wood_constraint")
model.addConstr(30*x + 20*y <= 900, "paint_constraint")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of drones to produce: {x.x}")
    print(f"Number of cars to produce: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

