
from gurobipy import *

# Create a new model
model = Model("Toys_Profit_Maximization")

# Define decision variables
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="RC_Drones")
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="Model_Cars")

# Set the objective function: Maximize profit
model.setObjective(50*x1 + 90*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(7*x1 + 4*x2 <= 200, "Wood_Constraint")
model.addConstr(30*x1 + 20*x2 <= 900, "Paint_Constraint")

# Optimize the model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal Production - RC Drones: {x1.x}, Model Cars: {x2.x}")
    print(f"Maximum Profit: ${model.objVal:.2f}")
else:
    print("Model is infeasible or unbounded.")
