
import gurobi as gp

# Create a new model
model = gp.Model("ABC_Toys_Optimization")

# Define the decision variables
x = model.addVar(name="RC_Drones", lb=0, vtype=gp.GRB.INTEGER)  # Number of RC drones
y = model.addVar(name="Model_Cars", lb=0, vtype=gp.GRB.INTEGER)  # Number of model cars

# Define the objective function
model.setObjective(50*x + 90*y, sense=gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(7*x + 4*y <= 200, name="Wood_Constraint")
model.addConstr(30*x + 20*y <= 900, name="Paint_Constraint")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Number of RC drones to produce: {x.varValue}, Number of model cars to produce: {y.varValue}")
    print(f"Max Profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
