
import gurobipy as gp

# Create a new model
m = gp.Model("pie_shop")

# Create variables
x = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="apple_pies")
y = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="peach_pies")

# Set objective function
m.setObjective(7*x + 8*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x >= 15, "min_apple")
m.addConstr(y >= 12, "min_peach")
m.addConstr(x <= 20, "max_apple")
m.addConstr(y <= 18, "max_peach")
m.addConstr(x + y <= 30, "total_pies")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of apple pies: {x.x}")
    print(f"Number of peach pies: {y.x}")
    print(f"Maximum profit: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

