
from gurobipy import *

# Create a new model
m = Model("Pie_Shop_Optimization")

# Define variables
A = m.addVar(vtype=GRB.INTEGER, name="Apple_Pies")
P = m.addVar(vtype=GRB.INTEGER, name="Peach_Pies")

# Set objective function: Maximize profit
m.setObjective(7*A + 8*P, GRB.MAXIMIZE)

# Define constraints
m.addConstr(A >= 15, "Min_Apple_Pies")
m.addConstr(P >= 12, "Min_Peach_Pies")
m.addConstr(A <= 20, "Max_Apple_Pies")
m.addConstr(P <= 18, "Max_Peach_Pies")
m.addConstr(A + P <= 30, "Total_Pie_Crust_Limitation")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Make {A.x} apple pies and {P.x} peach pies.")
else:
    print("No optimal solution found. The model is likely infeasible.")

