
import gurobi

def solve_pie_shop_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=0, ub=20, name="apple_pies")  # Number of apple pies
    y = model.addVar(lb=0, ub=18, name="peach_pies")  # Number of peach pies

    # Update model to include new variables
    model.update()

    # Objective function: Maximize profit
    model.setObjective(7 * x + 8 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x >= 15, name="min_apple_pies")
    model.addConstr(y >= 12, name="min_peach_pies")
    model.addConstr(x <= 20, name="max_apple_pies")
    model.addConstr(y <= 18, name="max_peach_pies")
    model.addConstr(x + y <= 30, name="total_pies_limit")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal profit: {model.objVal}")
        print(f"Number of apple pies: {x.varValue}")
        print(f"Number of peach pies: {y.varValue}")
    else:
        print("No optimal solution found.")

solve_pie_shop_problem()
