
from gurobipy import *

# Create a model
m = Model("Engineering_Firm")

# Define variables
E = m.addVar(vtype=GRB.CONTINUOUS, name="Engineers")
I = m.addVar(vtype=GRB.CONTINUOUS, name="Interns")

# Objective function: Minimize total wages
m.setObjective(3000*E + 750*I, GRB.MINIMIZE)

# Constraints
m.addConstr(E + I >= 100, "Total_Workers")
m.addConstr(I >= 20, "Minimum_Interns")
m.addConstr(I >= (1/3)*E, "Intern_to_Engineer_Ratio")
m.addConstr(3000*E + 750*I <= 200000, "Payroll_Limit")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Engineers: {E.x}")
    print(f"Interns: {I.x}")
    print(f"Total wages: ${3000*E.x + 750*I.x:.2f}")
else:
    print("No optimal solution found")
