
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    E = model.addVar(lb=0, name="Engineers", vtype=gurobi.GRB.INTEGER)
    I = model.addVar(lb=0, name="Interns", vtype=gurobi.GRB.INTEGER)

    # Objective: Minimize wages
    model.setObjective(3000*E + 750*I, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(E + I >= 100, name="Total_Workers")
    model.addConstr(I >= 20, name="Min_Interns")
    model.addConstr(I >= E/3, name="Intern_to_Engineer_Ratio")
    model.addConstr(3000*E + 750*I <= 200000, name="Max_Payroll")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Engineers: {E.varValue}")
        print(f"Interns: {I.varValue}")
        print(f"Total Wages: ${3000*E.varValue + 750*I.varValue}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
