
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Minimize_Cost")

# Create variables
x = m.addVar(lb=0, name="pork_servings")
y = m.addVar(lb=0, name="shrimp_servings")

# Set objective function
m.setObjective(6.5 * x + 9 * y, GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * x + 5 * y >= 25, "calcium_constraint")
m.addConstr(5 * x + 9 * y >= 35, "magnesium_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal:.2f}")
    print(f"Pork Servings: {x.x:.2f}")
    print(f"Shrimp Servings: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

