
from gurobipy import *

# Create a new model
m = Model("Nutrition_Optimization")

# Define decision variables
x1 = m.addVar(name="pork_servings", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="shrimp_servings", vtype=GRB.CONTINUOUS, lb=0)

# Set objective function: minimize cost
m.setObjective(6.5*x1 + 9*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 5*x2 >= 25, name="calcium_constraint")
m.addConstr(5*x1 + 9*x2 >= 35, name="magnesium_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pork servings: {x1.x}")
    print(f"Shrimp servings: {x2.x}")
    print(f"Total cost: ${6.5*x1.x + 9*x2.x:.2f}")
else:
    print("No optimal solution found.")
