
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x = model.addVar(lb=0, name="pork_meat_servings")
    y = model.addVar(lb=0, name="shrimp_meat_servings")

    # Define the objective function
    model.setObjective(6.5 * x + 9 * y, gurobi.MINIMIZE)

    # Add constraints
    model.addConstr(3 * x + 5 * y >= 25, name="calcium_constraint")
    model.addConstr(5 * x + 9 * y >= 35, name="magnesium_constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.OPTIMAL:
        print("Optimal solution found.")
        print(f"Optimal servings of pork meat: {x.varValue}")
        print(f"Optimal servings of shrimp meat: {y.varValue}")
        print(f"Minimum cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

# Run the optimization problem
solve_optimization_problem()
