
import gurobipy as gp
from gurobipy import GRB

try:

    # Create a new model
    m = gp.Model("butcher_shop")

    # Create variables
    x = m.addVar(vtype=GRB.INTEGER, name="burgers")
    y = m.addVar(vtype=GRB.INTEGER, name="sausages")

    # Set objective
    m.setObjective(5*x + 3*y, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(20*x + 10*y <= 1000, "meat_constraint")
    m.addConstr(y >= 3*x, "sales_ratio")
    m.addConstr(x >= 10, "min_burgers")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print(f"Optimal profit: ${m.objVal:.2f}")
        print(f"Number of burgers: {x.x}")
        print(f"Number of sausages: {y.x}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

