
from gurobipy import *

# Create a model
m = Model("Meat_Problem")

# Define variables
B = m.addVar(lb=0, vtype=GRB.INTEGER, name="burgers")
S = m.addVar(lb=0, vtype=GRB.INTEGER, name="sausages")

# Objective function: Maximize profit
m.setObjective(5*B + 3*S, GRB.MAXIMIZE)

# Constraints
m.addConstr(20*B + 10*S <= 1000, "ground_meat_constraint")
m.addConstr(B >= 10, "minimum_burgers")
m.addConstr(S >= 3*B, "sausage_to_burger_ratio")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: {B.varName} = {int(B.x)}, {S.varName} = {int(S.x)}")
    print(f"Maximum Profit: ${5*int(B.x) + 3*int(S.x)}")
else:
    print("Model is infeasible")
