
import gurobi

def solve_butcher_shop_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    B = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="Burgers")
    S = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="Sausages")

    # Objective function: Maximize profit
    model.setObjective(5 * B + 3 * S, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(20 * B + 10 * S <= 1000, name="Meat_Constraint")
    model.addConstr(S >= 3 * B, name="Sausages_to_Burgers_Ratio")
    model.addConstr(B >= 10, name="Minimum_Burgers")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found.")
        print(f"Burgers: {B.varValue}")
        print(f"Sausages: {S.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_butcher_shop_problem()
