
import gurobipy as gp

# Create a new model
model = gp.Model("PhoneProduction")

# Create decision variables
x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")  # Regular phones
x2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")  # Premium phones

# Set objective function
model.setObjective(200*x1 + 300*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 <= 20, "RegularDemand")
model.addConstr(x2 <= 15, "PremiumDemand")
model.addConstr(x1 + x2 <= 30, "TotalSales")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of regular phones (x1): {x1.x}")
    print(f"Number of premium phones (x2): {x2.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {model.status}")

