
from gurobipy import *

# Create a new model
m = Model("Phone_Sales_Optimization")

# Define variables
x1 = m.addVar(name="regular_phones", lb=0, ub=20)  # Regular phones sold per day
x2 = m.addVar(name="premium_phones", lb=0, ub=15)  # Premium phones sold per day

# Objective function: Maximize profit
m.setObjective(200*x1 + 300*x2, GRB.MAXIMIZE)

# Constraint: Total sales limit
m.addConstr(x1 + x2 <= 30, name="total_sales_limit")

# Solve the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found.")
    print(f"Sell {x1.x} regular phones and {x2.x} premium phones per day to maximize profit.")
    print(f"Maximum profit: ${200*x1.x + 300*x2.x}")
else:
    print("No optimal solution found. The problem might be infeasible.")

