
import gurobi

def solve_phone_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="regular_phones")  # Number of regular phones
    x2 = model.addVar(lb=0, name="premium_phones")  # Number of premium phones

    # Objective function: Maximize profit
    model.setObjective(200*x1 + 300*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 <= 20, name="regular_demand_constraint")
    model.addConstr(x2 <= 15, name="premium_demand_constraint")
    model.addConstr(x1 + x2 <= 30, name="total_sales_constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum profit: ${200*x1.varValue + 300*x2.varValue}")
    else:
        print("The model is infeasible.")

solve_phone_problem()
