
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("furniture_production")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="coffee_tables")
y = m.addVar(vtype=GRB.CONTINUOUS, name="bedside_tables")

# Set objective function
m.setObjective(50*x + 90*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2.5*x + 4.5*y <= 6500, "parts_production")
m.addConstr(3*x + 2*y <= 3500, "assembly")
m.addConstr(1.5*x + 3.5*y <= 5000, "polishing")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Coffee Tables: {x.x}")
    print(f"Number of Bedside Tables: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

