
from gurobipy import *

# Create a new model
m = Model("Furniture_Production")

# Define the decision variables
x_c = m.addVar(lb=0, vtype=GRB.INTEGER, name="coffee_tables")
x_b = m.addVar(lb=0, vtype=GRB.INTEGER, name="bedside_tables")

# Set the objective function
m.setObjective(50*x_c + 90*x_b, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2.5*x_c + 4.5*x_b <= 6500, "parts_production")
m.addConstr(3*x_c + 2*x_b <= 3500, "assembly")
m.addConstr(1.5*x_c + 3.5*x_b <= 5000, "polishing")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Coffee tables: {x_c.x}")
    print(f"Bedside tables: {x_b.x}")
    print(f"Total profit: ${50*x_c.x + 90*x_b.x}")
else:
    print("No optimal solution found")
