
import gurobi

# Create a new model
model = gurobi.Model()

# Define the decision variables
x = model.addVar(name="coffee_tables", lb=0, ub=None, obj=50)
y = model.addVar(name="bedside_tables", lb=0, ub=None, obj=90)

# Define the constraints
model.addConstr(2.5 * x + 4.5 * y <= 6500, name="parts_production")
model.addConstr(3 * x + 2 * y <= 3500, name="parts_assembly")
model.addConstr(1.5 * x + 3.5 * y <= 5000, name="polishing")

# Set the objective function to maximize
model.setObjective(x.obj + y.obj, gurobi.GRB.MAXIMIZE)

# Optimize the model
model.optimize()

# Print the results
if model.status == gurobi.GRB.OPTIMAL:
    print(f"Coffee tables: {x.x:.2f}")
    print(f"Bedside tables: {y.x:.2f}")
    print(f"Max profit: {model.objVal:.2f}")
else:
    print("The model is infeasible")
