
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("bus_seating")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="premium_seats")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="regular_seats")

# Set objective function
m.setObjective(50*x + 30*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 100, "capacity")
m.addConstr(x >= 30, "min_premium")
m.addConstr(y >= 2*x, "regular_demand")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: {m.objVal}")
    print(f"Premium seats: {x.x}")
    print(f"Regular seats: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

