
from gurobipy import *

# Create a model
m = Model("Bus_Seating")

# Define variables
P = m.addVar(vtype=GRB.INTEGER, name="Premium_Seats")
R = m.addVar(vtype=GRB.INTEGER, name="Regular_Seats")

# Set objective function: Maximize profit
m.setObjective(50*P + 30*R, GRB.MAXIMIZE)

# Add constraints
m.addConstr(P + R <= 100, "Total_Seats_Constraint")
m.addConstr(P >= 30, "Premium_Class_Minimum")
m.addConstr(R >= 2*P, "Regular_vs_Premium_Ratio")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Premium Seats: {P.x}")
    print(f"Regular Seats: {R.x}")
    print(f"Maximum Profit: ${50*P.x + 30*R.x}")
else:
    print("No optimal solution found. The model is either infeasible or unbounded.")
