
import gurobi

def solve_bus_seating_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(lb=30, name="premium_seats")  # At least 30 premium seats
    y = model.addVar(name="regular_seats")

    # Objective function: Maximize profit
    model.setObjective(50 * x + 30 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x + y <= 100, name="bus_capacity")
    model.addConstr(y >= 2 * x, name="passenger_preference")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Premium Seats = {x.varValue}, Regular Seats = {y.varValue}")
        print(f"Maximum Profit: ${50 * x.varValue + 30 * y.varValue}")
    else:
        print("The model is infeasible.")

solve_bus_seating_problem()
