
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("CafeOptimization")

# Create decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="lattes")  # Number of lattes
y = m.addVar(vtype=GRB.CONTINUOUS, name="cappuccinos") # Number of cappuccinos

# Set objective function
m.setObjective(2*x + 1*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x + 2*y <= 80, "milk_constraint")
m.addConstr(1*x + 2*y <= 50, "coffee_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Lattes: {x.x}")
    print(f"Number of Cappuccinos: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

