
from gurobipy import *

# Create a new model
m = Model("Cafe_Optimization")

# Define the decision variables
lattes = m.addVar(lb=0, vtype=GRB.INTEGER, name="Lattes")
cappuccinos = m.addVar(lb=0, vtype=GRB.INTEGER, name="Cappuccinos")

# Set the objective function
m.setObjective(2*lattes + cappuccinos, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*lattes + 2*cappuccinos <= 80, "Milk_Constraint")
m.addConstr(lattes + 2*cappuccinos <= 50, "Coffee_Constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Lattes: {lattes.x}")
    print(f"Cappuccinos: {cappuccinos.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
