
import gurobi

def solve_cafe_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    L = model.addVar(lb=0, name="Lattes")
    C = model.addVar(lb=0, name="Cappuccinos")

    # Define the objective function
    model.setObjective(2*L + C, gurobi.GRB.MAXIMIZE)

    # Define the milk constraint
    model.addConstr(4*L + 2*C <= 80, name="Milk_Constraint")

    # Define the coffee constraint
    model.addConstr(L + 2*C <= 50, name="Coffee_Constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Lattes = {L.varValue}, Cappuccinos = {C.varValue}")
        print(f"Maximum profit: ${2*L.varValue + C.varValue:.2f}")
    else:
        print("No optimal solution found")

solve_cafe_problem()
