
import gurobipy as gp

# Create a new model
model = gp.Model("Furniture Production")

# Create decision variables
x = model.addVar(vtype=gp.GRB.INTEGER, name="bookcases")
y = model.addVar(vtype=gp.GRB.INTEGER, name="garden_chairs")

# Set objective function
model.setObjective(270*x + 350*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*x + 2*y <= 80, name="woodworking")
model.addConstr(2*x + 4*y <= 70, name="nails")
model.addConstr(3*x + 3*y <= 90, name="varnish")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of bookcases: {x.x}")
    print(f"Number of garden chairs: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
else:
    print("No solution found.")

