
from gurobipy import *

# Create a new model
m = Model("Nu_Designs_Optimization")

# Define variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bookcases")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="garden_chairs")

# Set the objective function
m.setObjective(270*x + 350*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x + 2*y <= 80, "woodworking_hours")
m.addConstr(2*x + 4*y <= 70, "nails_boxes")
m.addConstr(3*x + 3*y <= 90, "varnish_units")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bookcases to make: {x.x}")
    print(f"Garden chairs to make: {y.x}")
    print(f"Maximum profit: ${270*x.x + 350*y.x:.2f}")
else:
    print("No optimal solution found")
