
import gurobi as gp

# Create a new model
m = gp.Model("bookcases_and_chairs")

# Define the decision variables
B = m.addVar(name="bookcases", lb=0, vtype=gp.GRB.CONTINUOUS)
G = m.addVar(name="garden_chairs", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: maximize profit
m.setObjective(270*B + 350*G, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(3*B + 2*G <= 80, name="woodworking")
m.addConstr(2*B + 4*G <= 70, name="nails")
m.addConstr(3*B + 3*G <= 90, name="varnish")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Bookcases to make: {B.varValue:.2f}")
    print(f"Garden chairs to make: {G.varValue:.2f}")
else:
    print("The problem is infeasible or no solution exists.")
