
import gurobipy as gp

# Create a new model
model = gp.Model("UmbrellaProfit")

# Create decision variables
r = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="red_umbrellas")
b = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="blue_umbrellas")

# Set objective function
model.setObjective(3*r + 5*b, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(r + b <= 100, "total_umbrellas")
model.addConstr(r >= 10, "min_red")
model.addConstr(b >= 4*r, "blue_popularity")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Red Umbrellas: {r.x}")
    print(f"Number of Blue Umbrellas: {b.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

