
from gurobipy import *

# Create a model
m = Model("Souvenir_Shop_Optimization")

# Define variables
R = m.addVar(vtype=GRB.INTEGER, name="Red_Umbrellas")
B = m.addVar(vtype=GRB.INTEGER, name="Blue_Umbrellas")

# Set the objective function: Maximize profit
m.setObjective(3*R + 5*B, GRB.MAXIMIZE)

# Define constraints
m.addConstr(R + B <= 100, "Total_Umbrellas")
m.addConstr(R >= 10, "Minimum_Red_Umbrellas")
m.addConstr(B >= 4*R, "Blue_vs_Red_Preference")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Red Umbrellas: {R.x}")
    print(f"Blue Umbrellas: {B.x}")
    print(f"Total Profit: ${3*R.x + 5*B.x}")
else:
    print("No optimal solution found. The model is likely infeasible.")
