
import gurobi

def solve_umbrella_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    R = model.addVar(lb=10, name="Red_Umbrellas")  # Minimum of 10 red umbrellas
    B = model.addVar(name="Blue_Umbrellas")

    # Objective function: Maximize profit
    model.setObjective(3*R + 5*B, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(R + B <= 100, name="Total_Umbrellas")  # At most 100 umbrellas
    model.addConstr(B >= 4*R, name="Blue_Preference")  # Blue umbrellas preference

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Red Umbrellas = {R.varValue}, Blue Umbrellas = {B.varValue}")
        print(f"Maximum Profit: ${3*R.varValue + 5*B.varValue}")
    else:
        print("The model is infeasible.")

solve_umbrella_problem()
