
import gurobipy as gp

# Create a new model
m = gp.Model("basketball_shots")

# Create variables
x = m.addVar(vtype=gp.GRB.INTEGER, name="x") # short shots
y = m.addVar(vtype=gp.GRB.INTEGER, name="y") # long shots

# Set objective
m.setObjective(2*x + 5*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 14, "total_shots")
m.addConstr(x >= 5, "min_short")
m.addConstr(y >= 2, "min_long")
m.addConstr(x <= 8, "max_short")
m.addConstr(y <= 8, "max_long")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal score: {m.objVal}")
    print(f"Number of short shots (x): {x.x}")
    print(f"Number of long shots (y): {y.x}")
else:
    print("Infeasible or unbounded")

