
from gurobipy import *

# Create a new model
m = Model("Shot_Optimization")

# Define variables
x = m.addVar(name='short_shots', vtype=GRB.INTEGER, lb=5, ub=8)
y = m.addVar(name='long_shots', vtype=GRB.INTEGER, lb=2, ub=8)

# Define the objective function: Maximize total score
m.setObjective(2*x + 5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 14, name='total_shots')

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Maximum score: {m.objVal}")
    print(f"Short shots: {x.x}")
    print(f"Long shots: {y.x}")
else:
    print("Model is infeasible")

