
import gurobi

def solve_shot_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    S = model.addVar(lb=0, ub=8, vtype=gurobi.GRB.INTEGER, name="Short Shots")
    L = model.addVar(lb=0, ub=8, vtype=gurobi.GRB.INTEGER, name="Long Shots")

    # Objective function: Maximize 2S + 5L
    model.setObjective(2 * S + 5 * L, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(S + L <= 14, name="Total Shots")
    model.addConstr(S >= 5, name="Min Short Shots")
    model.addConstr(L >= 2, name="Min Long Shots")
    model.addConstr(S <= 8, name="Max Short Shots")
    model.addConstr(L <= 8, name="Max Long Shots")

    # Update model
    model.update()

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Short Shots = {S.varValue}, Long Shots = {L.varValue}")
        print(f"Maximum Score: {2 * S.varValue + 5 * L.varValue}")
    else:
        print("The model is infeasible.")

solve_shot_optimization()
