
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Autumn_Auto_Advertising")

# Create decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="talent_show_ads")
y = m.addVar(vtype=GRB.CONTINUOUS, name="global_news_ads")

# Set objective function
m.setObjective(80000 * x + 30000 * y, GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * x + 13 * y >= 50, "baby_boomers_reach")
m.addConstr(20 * x + 7 * y >= 30, "millennials_reach")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal}")
    print(f"Number of Talent Show Ads: {x.x}")
    print(f"Number of Global News Ads: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

