
from gurobipy import *

# Create a new model
m = Model("Autumn_Auto_Advertising")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="talent_show_ads")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="global_news_commercials")

# Set the objective function
m.setObjective(80000*x1 + 30000*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5000000*x1 + 13000000*x2 >= 50000000, "baby_boomers")
m.addConstr(20000000*x1 + 7000000*x2 >= 30000000, "millennials")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Talent show ads: {x1.x}")
    print(f"Global news commercials: {x2.x}")
    print(f"Total cost: ${80000*x1.x + 30000*x2.x}")
else:
    print("No optimal solution found")
