
import gurobi

def autumn_auto_advertising():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="talent_show_ads", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="global_news_ads", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Minimize cost
    model.setObjective(80000*x1 + 30000*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(5*x1 + 13*x2 >= 50, name="baby_boomers")
    model.addConstr(20*x1 + 7*x2 >= 30, name="millennials")

    # Solve the model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Talent Show Ads: {x1.varValue}")
        print(f"Global News Ads: {x2.varValue}")
        print(f"Minimum Cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    autumn_auto_advertising()
