
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("tea_production")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="low_quality")
y = m.addVar(vtype=GRB.CONTINUOUS, name="medium_quality")
z = m.addVar(vtype=GRB.CONTINUOUS, name="high_quality")


# Set objective
m.setObjective(1*x + 3*y + 5*z, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x + 3*y + 4*z <= 200, "rare_additives")
m.addConstr(6*x + 7*y + 8*z <= 400, "tea_leaves")

# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Optimal objective:', m.objVal)
    print('x:', x.x)
    print('y:', y.x)
    print('z:', z.x)
elif m.status == GRB.INF_OR_UNBD:
    print('Model is infeasible or unbounded')
    m.computeIIS()  # Compute Irreducible Inconsistent Subsystem
    m.write("model_iis.ilp") # Write the IIS to a file
    print('See model_iis.ilp for the IIS.')
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
    m.computeIIS()
    m.write("model_iis.ilp")
    print('See model_iis.ilp for the IIS.')
elif m.status == GRB.UNBOUNDED:
    print('Model is unbounded')
else:
    print('Optimization ended with status %d' % m.status)

