
from gurobipy import *

# Create a model
m = Model("Tea_Optimization")

# Define decision variables
L = m.addVar(name="Low_Quality_Tea", lb=0)
M = m.addVar(name="Medium_Quality_Tea", lb=0)
H = m.addVar(name="High_Quality_Tea", lb=0)

# Set the objective function
m.setObjective(L + 3*M + 5*H, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*L + 3*M + 4*H <= 200, name="Rare_Additives_Constraint")
m.addConstr(6*L + 7*M + 8*H <= 400, name="Tea_Leaves_Constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Low Quality Tea: {L.x}")
    print(f"Medium Quality Tea: {M.x}")
    print(f"High Quality Tea: {H.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found.")
