
import gurobipy as gp

# Create a new model
model = gp.Model("TeaProduction")

# Define the decision variables
L = model.addVar(lb=0, name="LowQualityTea")
M = model.addVar(lb=0, name="MediumQualityTea")
H = model.addVar(lb=0, name="HighQualityTea")

# Define the objective function
model.setObjective(L + 3 * M + 5 * H, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2 * L + 3 * M + 4 * H <= 200, name="RareAdditives")
model.addConstr(6 * L + 7 * M + 8 * H <= 400, name="TeaLeaves")

# Solve the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Low Quality Tea: {L.varValue}")
    print(f"Medium Quality Tea: {M.varValue}")
    print(f"High Quality Tea: {H.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible")
